/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PILEDDataBean;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CSVRecord;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PILEDList {
    private static final int NUM_VALID_PARMS = 6;
    private boolean m_header;
    private String m_format;
    private String m_filter;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_type;
    private HashMap m_validParms = new HashMap(13, 0.5f);
    private PIHSCCECClient m_cecClient = null;
    private String m_delimiter = ",";
    private String[] m_filterPartNames = null;
    private String[] m_filterPartIDs = null;
    private PrintStream m_outStream;
    private boolean m_writeStatus;

    private PILEDList(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_cecClient = pIHSCCECClient;
        this.m_outStream = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--filter", null);
        this.m_validParms.put("--header", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-t", null);
    }

    private void doSystemAttentionList() throws PIHscClientException {
        String[] stringArray;
        PILEDDataBean pILEDDataBean = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        Vector<PILEDDataBean> vector = new Vector<PILEDDataBean>();
        PICECDataBean pICECDataBean = this.m_cecClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if (this.m_type.equals("phys") || this.m_type.equals("virtualsys")) {
            if (n == 254 || n == 241 || n == 242 || n == 250) {
                String[] stringArray4 = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray4, null);
            }
        } else if (n != 17 && n != 1) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
        }
        if (this.m_type.equals("phys")) {
            pILEDDataBean = this.m_cecClient.getSALEDInfo("phys");
            vector.add(pILEDDataBean);
        } else if (this.m_type.equals("virtualsys")) {
            pILEDDataBean = this.m_cecClient.getSALEDInfo("virtualsys");
            vector.add(pILEDDataBean);
        } else if (this.m_type.equals("virtuallpar")) {
            String[] stringArray5;
            if (this.m_filterPartIDs != null) {
                stringArray3 = this.m_filterPartIDs;
            } else if (this.m_filterPartNames != null) {
                stringArray3 = this.m_filterPartNames;
            }
            stringArray = new String[1];
            if (null == stringArray3 || stringArray3.length == 0) {
                String[] stringArray6 = new String[2];
                stringArray5 = this.m_cecClient.getPartitionNames();
                stringArray3 = new String[stringArray5.size()];
                for (int i = 0; i < stringArray5.size(); ++i) {
                    stringArray6 = (String[])stringArray5.get(i);
                    stringArray3[i] = stringArray6[1];
                }
            }
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray5 = new String[]{stringArray3[i]};
                pILEDDataBean = this.m_cecClient.getVirtualPartitionSALEDInfo(stringArray5, this.m_filterPartIDs != null);
                vector.add(pILEDDataBean);
            }
        }
        stringArray = new String[]{"lpar_id", "lpar_name", "state"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray, stringArray.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray2 = PICmdOutputUtils.checkKeys(stringArray, this.m_format, this.m_delimiter);
        } else {
            stringArray2 = stringArray;
        }
        PICmdOutputUtils.printResults(this.m_outStream, this.m_writeStatus, vector.elements(), stringArray2, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        if ("sa".equals(this.m_resourceType)) {
            this.doSystemAttentionList();
        }
    }

    private void parseFilter(String string) throws PIHscClientException {
        CSVRecord cSVRecord = new CSVRecord(string, true, ",");
        Iterator iterator = cSVRecord.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = string2.indexOf("=");
            if (n == -1) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER", null, null);
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.length() == 0 || string4.length() == 0) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER", null, null);
            }
            if ("lpar_names".equals(string3)) {
                this.m_filterPartNames = PIHMCCommandUtils.parseList(string4, ",");
                continue;
            }
            if ("lpar_ids".equals(string3)) {
                this.m_filterPartIDs = PIHMCCommandUtils.parseList(string4, ",");
                continue;
            }
            String[] stringArray = new String[]{string3};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_NAME", stringArray, null);
        }
        if (this.m_filterPartNames != null && this.m_filterPartIDs != null) {
            String[] stringArray = new String[]{"lpar_names, lpar_ids"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_FILTER_NAMES", stringArray, null);
        }
    }

    private void validateParameterValues() throws PIHscClientException {
        String string = "";
        if (this.m_resourceType != null && !this.m_resourceType.equals("sa")) {
            String[] stringArray = new String[]{"sa"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_LED_RESOURCE_TYPE", stringArray, null);
        }
        if (!(this.m_type == null || this.m_type.equals("phys") || this.m_type.equals("virtuallpar") || this.m_type.equals("virtualsys"))) {
            String[] stringArray = new String[]{"phys, virtuallpar, virtualsys"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_LED_TYPE", stringArray, null);
        }
        if (this.m_filter != null) {
            this.parseFilter(this.m_filter);
        }
    }

    private void checkParameters() throws PIHscClientException {
        String[] stringArray = null;
        String string = new String();
        if (this.m_resourceType == null || this.m_resourceType.length() == 0) {
            string = string + ", -r";
        }
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (this.m_type == null || this.m_type.length() == 0) {
            string = string + ", -t";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        this.validateParameterValues();
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_type = (String)hashMap.get("-t");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
        this.m_filter = (String)hashMap.get("--filter");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSLED_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PILEDList pILEDList = new PILEDList(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pILEDList.m_validParms);
            pILEDList.mapParameters(hashMap);
            pILEDList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

